<?php

/**
 * Contains events listeners handlers.
 */
abstract class GlobKurierListener
{
    /**
     * Adds custom backend generation to stOrder.
     *
     * @param sfEvent $event
     */
    public static function generateStOrder(sfEvent $event)
    {
        $event->getSubject()->attachAdminGeneratorFile('appGlobKurierPlugin', 'stOrder.yml');
    }

    /**
     * Passes GlobBox point id from basket form.
     *
     * @param sfEvent $event
     */
    public static function postOrderConfirm(sfEvent $event)
    {
        if ($globBox = $event->getSubject()->getRequestParameter('order[glob_box]'))
        {
            $event->getSubject()->user_data_delivery['glob_box'] = $globBox;
        }

        if ($inPostTerminal = $event->getSubject()->getRequestParameter('order[in_post_terminal]'))
        {
            $event->getSubject()->user_data_delivery['in_post_terminal'] = $inPostTerminal;
        }
    }

    /**
     * Sets GlobBox point id on order.
     *
     * @param sfEvent $event
     */
    public static function postExecuteOrderSave(sfEvent $event)
    {
        $order = $event->getSubject()->order;
        $config = stConfig::getInstance('appGlobKurierBackend');
        $globBox = $event->getSubject()->getRequestParameter('user_data_delivery[glob_box]');
        $save = false;


        if ($config->get('glob_box_delivery_id') == $order->getOrderDelivery()->getDeliveryId() && $globBox)
        {
            $order->setGlobBox($globBox);

            $save = true;
        }

        $inPostTerminal = $event->getSubject()->getRequestParameter('user_data_delivery[in_post_terminal]');

        if ($config->get('in_post_delivery_id') == $order->getOrderDelivery()->getDeliveryId() && $inPostTerminal)
        {
            $order->setInPostTerminal($inPostTerminal);

            $save = true;
        }

        if ($save)
        {
            $order->save();
        }
    }
}
