<?php

/**
 * Represents GlobKurier API.
 */
abstract class GlobKurierApi
{
    const IS_DEV = false;

    const PROD_URL = 'http://www.';
    const DEV_URL = 'http://www.test.';

    const URL_LOGIN = 'webservices.globkurier.pl/services/login/';
    const URL_REGISTER = 'webservices.globkurier.pl/services/register/';
    const URL_EVALUATE = 'poprzedni.globkurier.pl/wycen.php/';
    const URL_GET_ADDONS = 'poprzedni.globkurier.pl/producent_dodatki.php/';
    const URL_ORDER = 'webservices.globkurier.pl/services/order/';
    const URL_GET_LABEL = 'webservices.globkurier.pl/services/label/';
    const URL_GET_POINTS = 'webservices.globkurier.pl/services/globbox/get_points/';
    const URL_GET_TERMINALS = 'webservices.globkurier.pl/services/terminal/';
    const URL_GET_COUNTRIES = 'webservices.globkurier.pl/services/country/';
    const URL_PRODUCT = 'webservices.globkurier.pl/services/product/';

    const GOOGLE_MAP_KEY = 'AIzaSyAibmBuxeWWRmWFpntqAD7PKTIJJwpB3A8';
    const GOOGLE_MAP_LAT = 52.0060044;
    const GOOGLE_MAP_LNG = 18.7097142;
    const GOOGLE_MAP_ZOOM = 6;

    protected static $curlHandle;

    /**
     * Makes call to API.
     *
     * @param string $url
     * @param array $data
     *
     * @return array
     */
    public static function call($url, $data)
    {
        self::open();

        $url = (GlobKurierApi::IS_DEV ? GlobKurierApi::DEV_URL : GlobKurierApi::PROD_URL).$url;

        curl_setopt(self::$curlHandle, CURLOPT_URL, $url);
        curl_setopt(self::$curlHandle, CURLOPT_POSTFIELDS, $data);

        return json_decode(curl_exec(self::$curlHandle), true);
    }

    /**
     * Opens API connection if it is not opened already.
     */
    protected static function open()
    {
        if (!self::$curlHandle)
        {
            self::$curlHandle = curl_init();

            curl_setopt(self::$curlHandle, CURLOPT_POST, 1);
            curl_setopt(self::$curlHandle, CURLOPT_RETURNTRANSFER, 1);
        }
    }
}
